function Cg = global_interaction_matrix(pos, alphae, alphah, alphaeh,...
    k, eps0, mu0)

% First step in CDDA calculations: calculation of the coupling matrix 
% between the Nt electric dipoles.

%%%%%% INPUT ARGUMENTS %%%%%%
%%% pos:     position of the dipoles                                 %%%
%%% alphae:  electric polarizabilities of the dipoles                %%%
%%% alphah:  magnetic polarizabilities of the dipoles                %%%
%%% alphaeh: mixed magnetic electric polarizabilities of the dipoles %%%
%%% k:       wavenumber                                              %%%
%%% eps0:    surrounding permittivity                                %%%
%%% mu0:     surrounding permeability                                %%%


%%%%%% OUTPUT ARGUMENTS %%%%%%
%%% alphae: 6*Ntx6*Nt global coupling matrix neccesary for the next steps
% of the DDA calculations.
            

% Data for loops %
Nt = length(pos(:,1));
Cg = zeros(6*Nt,6*Nt);


% If L = 2, the polarizability is wavelength indepndent and the same for
% all dipole. If K>1 and L = 3 the polarizability is only a function of
% the wavelength and if L = 4 it also depends on the position (dipole).
% If K = 1 and L = 3 it only depndends on the position and if L = 2 the
% polarizability is wavelength independent and the same for all dipoles.
S = size(alphae);
L = length(S);

if(L > 2) %all dipoles different polarizabilty
    for i = 1:6:6*Nt
        for j = 1:6:6*Nt

            if(i == j)
                
                Cg(i:i+5,j:j+5) = -eye(6);
                
            else
                
                rji = [pos((i+5)/6,1)-pos((j+5)/6,1),...
                    pos((i+5)/6,2)-pos((j+5)/6,2),...
                    pos((i+5)/6,3)-pos((j+5)/6,3)];
                R   = norm(rji);
                
                if(R == 0)
                    
                    fprintf("Warning: two dipoles in the same place");
                    Cg(i:i+5,j:j+5) = zeros(6);
                    
                else   
                    
                    nji = rji/R;
                    Cg(i:i+5,j:j+5) = dipoles_coupling_matrix(k, nji,...
                        R, alphae((j+5)/6,:,:), alphah((j+5)/6,:,:),...
                        alphaeh((j+5)/6,:,:), eps0, mu0);
                    
                end
            end
        end
    end
    
else %all dipoles same polarizabilty   
    for i = 1:6:6*Nt
        for j = i:6:6*Nt  

            if(i == j)
                
                Cg(i:i+5,j:j+5) = -eye(6);
                
            else
                
                rji = [pos((i+5)/6,1)-pos((j+5)/6,1),...
                    pos((i+5)/6,2)-pos((j+5)/6,2),...
                    pos((i+5)/6,3)-pos((j+5)/6,3)];
                R   = norm(rji);
                
                if(R == 0)
                    
                    fprintf("Warning: two dipoles in the same place");
                    Cg(i:i+5,j:j+5) = zeros(6);
                    
                else   
                    
                    nji = rji/R;
                    Cg(i:i+5,j:j+5) = dipoles_coupling_matrix(k,  nji,...
                        R, alphae, alphah, alphaeh, eps0, mu0);
                    Cg(j:j+5,i:i+5) = dipoles_coupling_matrix(k, -nji,...
                        R, alphae, alphah, alphaeh, eps0, mu0);
                    
                end
            end
        end
    end
    

end

end

